import React, { useEffect, useState } from 'react';

import { Tabs } from 'antd';
import type { TabsProps } from 'antd';
import { useRouter } from 'next/router';

import Layout from '~/components/layout';

import api, { ListPageFlyingInfoResp } from './api';
import { Box } from './styled';

const contentStyle: React.CSSProperties = {
  width: '100%',
};

export default function FlyingDetail() {
  const router = useRouter();
  const [detail, setDetail] = useState<ListPageFlyingInfoResp | null>();
  const onChange = (key: string) => {
    console.log(key);
  };

  const items: TabsProps['items'] = [
    {
      key: '1',
      label: `介绍`,
      children: (
        <div className='body'>
          <div className='top'>
            <div className='title'>课程简介</div>
            <div className='content'>{detail?.curriculumDesc}</div>
          </div>
          {/* <div className="bottom">详情</div> */}
          {detail?.detailContent && (
            <div dangerouslySetInnerHTML={{ __html: detail?.detailContent }}></div>
          )}
        </div>
      ),
    },
  ];

  useEffect(() => {
    if (Object.keys(router.query).length) {
      api.listPageJobServicesInfo({ id: Number(router.query.id) }).then((res) => {
        console.log(res);
        setDetail(res.result);
      });
    }
  }, [router]);
  return (
    <Layout contentStyle={contentStyle}>
      <Box>
        <div className='box'>
          <div className='box-body'>
            {/* eslint-disable-next-line jsx-a11y/media-has-caption */}
            <video className='body-video' controls src={detail?.videoUrl as string} />
          </div>
          <div className='box-bottom'>
            <div className='left'>
              <div className='top'>{detail?.curriculumName}</div>
              <div className='bottom'>免费</div>
            </div>
            <div className='right'>
              {/* <Button
              type="primary"
              className="btn"
              onClick={() =>
                router.push(`/flyingHandService/examination/${router.query.id}`)
              }
            >
              去考试
            </Button> */}
            </div>
          </div>
        </div>
        <div className='detail'>
          <Tabs className='tabs' defaultActiveKey='1' items={items} onChange={onChange} />
        </div>
      </Box>
    </Layout>
  );
}
